{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 15:04:27 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes,
  WinProcs,
{$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  MMObj,
  MMAVI,
  MMCstDlg;
  
type
  TTMainForm = class(TForm)
    btnPlay: TButton;
    btnFile: TButton;
    OpenDialog: TMMAVIOpenDialog;
    AVIMemoryFile: TMMAVIMemoryFile;
    Label1: TLabel;
    procedure btnPlayClick(Sender: TObject);
    procedure btnFileClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  public
    Stream: TMemoryStream;
  end;

var
  TMainForm: TTMainForm;

implementation

{$R *.DFM}

uses unit2;

procedure TTMainForm.FormCreate(Sender: TObject);
begin
   Stream := TMemoryStream.Create;
end;

procedure TTMainForm.FormDestroy(Sender: TObject);
begin
   Stream.Free;
end;

procedure TTMainForm.btnFileClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      Stream.Clear;
      Stream.LoadFromFile(OpenDialog.FileName);

      Label1.Caption := OpenDialog.FileName;
      btnPlay.Enabled := (Stream.Size > 0);
   end;
end;

procedure TTMainForm.btnPlayClick(Sender: TObject);
begin
   { this can be any valid stream }
   AVIMemoryFile.CreateFromMemoryStream(Stream);
   PlayFile(AVIMemoryFile);
   AVIMemoryFile.CloseFile;
end;

end.
